# 通知設計書 25-Windows Terminal未検出警告

## 概要

本ドキュメントは、StaxRipアプリケーションにおける「Windows Terminal未検出警告」通知の設計仕様を定義する。この通知は、コマンドラインプレビュー機能でWindows Terminalが見つからない場合にユーザーに警告を表示し、代替としてPowershellを使用することを通知するものである。

### 本通知の処理概要

この通知は、StaxRipでコマンドラインプレビュー機能を使用する際に、ユーザーがWindows Terminal表示を選択しているにも関わらず、システムにWindows Terminalがインストールされていない場合に表示される警告機能を提供する。

**業務上の目的・背景**：StaxRipはエンコード処理で使用するコマンドラインをプレビュー表示する機能を持つ。表示方法としてWindows Terminal、Powershell、CodePreviewの選択肢がある。Windows Terminalはモダンで高機能なターミナルアプリケーションであり、ユーザーがこれを選択している場合に、システムにインストールされていないと機能が使えないため、自動的にPowershellへフォールバックすることをユーザーに通知する必要がある。

**通知の送信タイミング**：ShowCommandLinePreview関数でコマンドラインプレビューを表示する際、設定がCommandLinePreview.WindowsTerminalであり、かつg.IsWindowsTerminalAvailableがFalseの場合に発生する。

**通知の受信者**：StaxRipアプリケーションを使用しているユーザー（操作者）がダイアログボックスを通じて警告通知を受け取る。

**通知内容の概要**：タイトル「Windows Terminal not found!」と本文「Windows Terminal could not be found and thus Powershell will be used to show the command line preview!」が警告ダイアログとして表示される。

**期待されるアクション**：ユーザーは警告を確認後、以下のいずれかの対応を行うことができる：(1) そのままPowershellでプレビューを確認する、(2) Windows Terminalをシステムにインストールする、(3) オプション設定でコマンドラインプレビュー方法をCodePreviewまたはPowershellに変更する。

## 通知種別

アプリ内通知（TaskDialog警告ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | 無し |

### 送信先決定ロジック

現在StaxRipを操作しているユーザーに対してモーダルダイアログとして表示される。警告表示後は自動的にPowershellへフォールバックして処理を継続する。

## 通知テンプレート

### ダイアログ通知の場合

| 項目 | 内容 |
|-----|------|
| アイコン | Warning（警告アイコン） |
| タイトル | Windows Terminal not found! |
| 本文 | Windows Terminal could not be found and thus Powershell will be used to show the command line preview! |
| ボタン | OK |

### 本文テンプレート

```
Windows Terminal not found!

Windows Terminal could not be found and thus Powershell will be used to show the command line preview!
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | コマンドラインプレビュー表示時 | s.CommandLinePreview = WindowsTerminal AND g.IsWindowsTerminalAvailable = False | Windows Terminal設定だが未インストール |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Windows Terminalがインストールされている | g.IsWindowsTerminalAvailable = Trueの場合は通知しない |
| CodePreview設定の場合 | s.CommandLinePreview = CodePreviewの場合は別処理 |
| Powershell設定の場合 | s.CommandLinePreview = Powershellの場合は直接Powershell起動 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ShowCommandLinePreview呼び出し] --> B{s.CommandLinePreview?}
    B -->|CodePreview| C[ShowCodePreview呼び出し]
    B -->|Powershell| D[Powershell起動]
    B -->|WindowsTerminal| E{IsWindowsTerminalAvailable?}
    E -->|True| F[Windows Terminal起動]
    E -->|False| G[MsgWarn呼び出し]
    G --> H[警告ダイアログ表示]
    H --> I[Powershellへフォールバック]
    C --> J[終了]
    D --> J
    F --> J
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | アプリケーション設定とシステム状態のみ参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 更新処理なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | - | 警告表示後、自動的にPowershellへフォールバック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じて即時表示）

## セキュリティ考慮事項

- 個人情報は含まれない
- ローカルアプリケーション内での表示のため、暗号化不要
- 認証不要

## 備考

- Windows Terminalは Microsoft Store または GitHub からインストール可能
- Windows 11ではデフォルトでインストールされている場合がある
- フォールバック先のPowershellは従来のWindows環境で広くサポートされている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

アプリケーション設定の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ApplicationSettings.vb | `Source/General/` | CommandLinePreviewプロパティの定義を確認 |
| 1-2 | Enums.vb | `Source/General/` | CommandLinePreview列挙型の定義を確認 |

**読解のコツ**: s.CommandLinePreviewはApplicationSettingsクラスのプロパティで、ユーザーが選択したプレビュー表示方法を保持する。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | ShowCommandLinePreview関数（行1374-1402）がエントリーポイント |

**主要処理フロー**:
1. **行1386**: Select Case s.CommandLinePreview - 設定に基づく分岐
2. **行1387-1388**: Case CodePreview - ShowCodePreview呼び出し
3. **行1389-1391**: Case Powershell - 直接Powershell起動
4. **行1392-1400**: Case WindowsTerminal - Windows Terminal処理
5. **行1395**: If g.IsWindowsTerminalAvailable Then - 存在確認
6. **行1396**: g.Execute("wt.exe", ...) - Windows Terminal起動
7. **行1397-1399**: Else MsgWarn(...) - 警告とPowershellフォールバック

#### Step 3: Windows Terminal検出ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GlobalClass.vb | `Source/General/GlobalClass.vb` | IsWindowsTerminalAvailableプロパティの実装を確認 |

**主要処理フロー**:
- **IsWindowsTerminalAvailable**: wt.exeがシステムPATHに存在するかを確認

### プログラム呼び出し階層図

```
MainForm / 各種メニュー
    │
    └─ g.ShowCommandLinePreview(title, value, lineNumbers)
           │
           ├─ (lineNumbers時) 行番号付加処理
           │
           └─ Select Case s.CommandLinePreview
                  │
                  ├─ Case CodePreview
                  │      └─ ShowCodePreview(value, Nothing, True)
                  │
                  ├─ Case Powershell
                  │      └─ g.Execute("powershell.exe", ...)
                  │
                  └─ Case WindowsTerminal
                         │
                         ├─ (IsWindowsTerminalAvailable = True)
                         │      └─ g.Execute("wt.exe", ...)
                         │
                         └─ (IsWindowsTerminalAvailable = False)
                                │
                                ├─ MsgWarn("Windows Terminal not found!", ...)
                                │
                                └─ g.Execute("powershell.exe", ...)
```

### データフロー図

```
[入力]               [処理]                    [出力]

s.CommandLinePreview ───▶ Select Case分岐 ───▶ 処理パス選択
     │
     │ (WindowsTerminal時)
     ▼
g.IsWindowsTerminalAvailable ───▶ Boolean判定
     │
     │ (False時)
     ▼
MsgWarn()            ───▶ TaskDialog表示    ───▶ ユーザーへの警告
     │
     ▼
g.Execute("powershell.exe") ───▶ プロセス起動 ───▶ Powershellウィンドウ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GlobalClass.vb | `Source/General/GlobalClass.vb` | ソース | ShowCommandLinePreview関数の実装、通知発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgWarn関数の実装 |
| ApplicationSettings.vb | `Source/General/` | ソース | CommandLinePreview設定の保持 |
| Misc.vb | `Source/General/Misc.vb` | ソース | グローバル変数sの定義 |
